/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.state;

import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.searchsupport.client.Actions;
import com.floragunn.signals.watch.state.WatchState;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;

public class WatchStateIndexReader {
    private static final Logger log = LogManager.getLogger(WatchStateIndexReader.class);
    private final String tenant;
    private final String indexName;
    private final String watchIdPrefix;
    private final Client client;

    public WatchStateIndexReader(String tenant, String watchIdPrefix, String indexName, Client client) {
        this.tenant = tenant;
        this.watchIdPrefix = watchIdPrefix;
        this.indexName = indexName;
        this.client = client;
    }

    public WatchState get(String watchId) throws IOException, DocumentParseException {
        String prefixedId = this.watchIdPrefix + watchId;
        GetResponse getResponse = (GetResponse)((GetRequestBuilder)this.client.prepareGet().setIndex(this.indexName)).setId(prefixedId).get();
        if (getResponse.isExists()) {
            return WatchState.createFromJson(this.tenant, getResponse.getSourceAsString());
        }
        throw new IOException("State of " + watchId + " does not exist: " + getResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WatchState> get(Collection<String> watchIds) {
        try {
            if (watchIds.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, WatchState> result = new HashMap<String, WatchState>(watchIds.size());
            IdsQueryBuilder queryBuilder = QueryBuilders.idsQuery().addIds((String[])watchIds.stream().map(watchId -> this.watchIdPrefix + watchId).toArray(String[]::new));
            if (log.isDebugEnabled()) {
                log.debug("Going to do query: " + queryBuilder);
            }
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setQuery((QueryBuilder)queryBuilder).setSize(1000).setScroll(new TimeValue(10000L)).get();
            try {
                do {
                    for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                        try {
                            result.put(searchHit.getId().substring(this.watchIdPrefix.length()), WatchState.createFromJson(this.tenant, searchHit.getSourceAsString()));
                        }
                        catch (Exception e) {
                            log.error("Error while loading " + searchHit, (Throwable)e);
                        }
                    }
                } while ((searchResponse = (SearchResponse)this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(new TimeValue(10000L)).execute().actionGet()).getHits().getHits().length != 0);
                if (log.isDebugEnabled()) {
                    log.debug("Got states: " + result);
                }
            }
            finally {
                Actions.clearScrollAsync((Client)this.client, (SearchResponse)searchResponse);
            }
            return result;
        }
        catch (ElasticsearchException e) {
            log.error("Error in WatchStateIndexReader.get()", (Throwable)e);
            throw e;
        }
    }
}

